package org.msh.tb.reports2.me;

import org.msh.tb.indicators.core.Indicator;
import org.msh.tb.reports2.ReportResources;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class CaseFindingReport {

    public static List<TableData> generate(IndicatorBuilder builder) {
        builder.setPeriod(IndicatorBuilder.IndicatorPeriod.REGISTRATION_DATE);

        List<TableData> tables = new ArrayList<TableData>();

        tables.add(generateTable1(builder));

        tables.add(generateTable2(builder.clear()));

        tables.add(generateTable3(builder.clear()));

        tables.add(generateTable4(builder.clear()));

        tables.add(generateTable5(builder.clear()));

        return tables;
    }

    private static TableData generateTable1(IndicatorBuilder builder) {
        String col = "groups PTB='Pulmonary TB cases' EPTB='EPTB cases'," +
                "bacresult is='PULMONARY;BOTH' group=PTB," +
                "totalcases key=1:'Clinically diagnosed' caseDef=CLINICALLY_DIAGNOSED is='PULMONARY;BOTH' group=PTB," +

                "bacresult is='EXTRAPULMONARY;BOTH' group=EPTB," +
                "totalcases key=1:'Clinically diagnosed' caseDef=CLINICALLY_DIAGNOSED is='EXTRAPULMONARY;BOTH' group=EPTB," +

                "totalcases key=1:'Unknown Site of Disease' is='isnull'," +
                "totalcases key=1:'Total TB cases notified'," +
                "totalcases key=1:'All TB cases who had Xpert test' xpert-result-diagnosis=notnull diagtype=1;2";

        TableData tbl = builder
                .addColumnVariables(col)
                .addRowVariables("patient-type-rep")
                .addFilter("diagtype", "1")
                .generate("Block 1. Break down of all TB cases registered during the quarter by category and type of diagnosis");

        return tbl;
    }


    private static TableData generateTable2(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables(ReportResources.VAR_GENDER)
                .addFilter("diagtype", "1") // CONFIRMED
                .generate("Block 2. Breakdown of the total (all forms) of TB cases registered during the quarter by sex and age group");
        return tbl;
    }


    private static TableData generateTable3(IndicatorBuilder builder) {
        TableData tbl = builder
                .addColumnVariables(ReportResources.VAR_AGERANGE3)
                .addRowVariables("gender")
                .addFilter("pt", "NEW,RELAPSE,UNKNOWN_PREVIOUS_TB_TREAT")
                .generate("Breakdown of new, relapse and previous treatment history unknown TB cases registered by sex and age group");
        return tbl;
    }

    private static TableData generateTable4(IndicatorBuilder builder) {
        String col = "classif," +
                "totalcases key=1:'Examined for diagnosis' caseDef=notnull," +
                "totalcases key=1:'Xpert positive' xpert-result-diagnosis=TB_DETECTED," +
                "totalcases key=1:'Smear positive' mic_res='1;2;3;4;5'," +
                "totalcases key=1:'Rifampicin Resistant cases' genx_rifres=RIF_DETECTED," +
                "hivres key=0:'HIV Positive' key=1:'HIV Negative' key=null:'HIV Unknown'," +
                "totalcases key=1:'Referred from the community' source-referral='939958;939960;939961;939963'";

        TableData tbl = builder
                .addColumnVariables(col)
                .addRowVariables("totalcases")
                .addFilter("is", "EXTRAPULMONARY,BOTH")
                .generate("Block 4. Breakdown of activities of all Presumptive PTB cases on the clinic register during the quarter");
        return tbl;
    }

    private static TableData generateTable5(IndicatorBuilder builder) {
        String col = "totalcases key=1:'Total TB cases notified', " +
                "hivres key=0:'HIV Positive' key=1:'HIV Negative' key=null:'HIV Unknown'," +
                "hiv_ctp key=1:'TB/HIV care - CPT' hiv_ctp=1," +
                "hiv_art key=1:'TB/HIV care - ART' hiv_art=1";

        TableData tbl = builder
                .addColumnVariables(col, "gender")
                .addRowVariables("patient-type-rep")
                .addFilter("patient-type-rep", "notnull")
                .generate("Block 5. Breakdown of TB/HIV activities by case category and sex");
        return tbl;
    }
}
